// v1.00 of the Simulator

#include <iostream>
#include "Fleet.h"
#include "Simulator.h"

class TestInterface{
public:
    void testFleetCreation(){
        Fleet* fleet=userInterfaceCreateFleet();
        writeFleet(fleet, "test_fleet.dat");
        delete fleet;
    }
    void testInterface(){
        Fleet* fleet=readFleet("0000000_fleet.dat");
        cout<<"fleet->getWeight(): "<<fleet->getWeight()<<endl;
        cout<<"fleet->getEnergyConsumption(): "<<fleet->getEnergyConsumption()<<endl;
        cout<<"fleet->getColonistCount(): "<<fleet->getColonistCount()<<endl;
        cout<<"fleet->getCost(): "<<fleet->getCost()<<endl;
        cout<<"fleet->getEnergyProduction(): "<<fleet->getEnergyProduction()<<endl;
        cout<<"fleet->hasMedic(): "<<fleet->hasMedic()<<endl;
        cout<<"fleet->getCorporationName(): "<<fleet->getCorporationName()<<endl;
        vector<Ship*> colonyShips=fleet->colonyShips();
        for(unsigned int i=0; i<colonyShips.size();i++){
            cout<<"colonyShips["<<i<<"]->TN(): "<<colonyShips[i]->getTypeName()<<"; ";
            ColonyShip* colonyShip=dynamic_cast<ColonyShip*>(colonyShips[i]);
            cout<<"->CC(): "<<colonyShip->getColonistCount()<<"; ";
            colonyShip->infect();
            cout<<"->I(): "<<colonyShip->isInfected()<<"; ";
            colonyShip->destroy();
            cout<<"->D(): "<<colonyShip->isDestroyed()<<endl;
        }
        vector<Ship*> ships=fleet->shipList();
        for(unsigned int i=0; i<ships.size();i++){
            cout<<"ships["<<i<<"]->EC(): "<<ships[i]->getEnergyConsumption()<<"; ";
            cout<<"->W(): "<<ships[i]->getWeight()<<"; ";
            cout<<"->C(): "<<ships[i]->getCost()<<"; ";
            cout<<"->T(): "<<ships[i]->getTypeName();
            SolarSailShip* sol=dynamic_cast<SolarSailShip*>(ships[i]);
            if(sol){
                cout<<"; sol->getEnergyProduction(): "<<sol->getEnergyProduction()<<endl;
            }else{
                cout<<endl;
            }
        }
        delete fleet;
    }
};

class RunSimulation{
public:
    void runSimulation(){
        Fleet* fleet1=readFleet("0000000_fleet.dat");
        Fleet* fleet2=readFleet("1111111_fleet.dat");
        Simulator sim = Simulator();
        sim.addFleet(fleet1);
        sim.addFleet(fleet2);
        sim.launchFleets();
        sim.report();
    }
};

int main(){
    bool debug=true;
    if(debug){
        TestInterface* test=new TestInterface();
        test->testFleetCreation();
        test->testInterface();
    }else{
        RunSimulation* run=new RunSimulation();
        run->runSimulation();
    }
    return 0;
}
